<?PHP
/**
* Disqus Comments Integration ( see: www.disqus.com )
*/
class disqus
	{
	/**
	* Build the javascript for the comments block
	*
	* @param string $website_shortname
	* @param string $disqus_identifier
	* @return string 
	*/
	function comment($website_shortname, $disqus_identifier)
		{
		return ("<div id=\"disqus_thread\"></div>
<script type=\"text/javascript\">
  /**
    * var disqus_identifier; [Optional but recommended: Define a unique identifier (e.g. post id or slug) for this thread] 
    */
  (function() {
   var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
   dsq.src = 'http://{$website_shortname}.disqus.com/embed.js';
   (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
  })();
</script>
<noscript>Please enable JavaScript to view the <a href=\"http://disqus.com/?ref_noscript={$website_shortname}\">comments powered by Disqus.</a></noscript>");
		}

	/**
	* Build the javascript for the comment count
	*
	* @param string $website_shortname
	* @return string 
	*/
	function comment_count($website_shortname)
		{
		return ("<script type=\"text/javascript\">
var disqus_shortname = '{$website_shortname}';
(function () {
  var s = document.createElement('script'); s.async = true;
  s.src = 'http://disqus.com/forums/spbas/count.js';
  (document.getElementsByTagName('HEAD')[0] || document.getElementsByTagName('BODY')[0]).appendChild(s);
}());
</script>");
		}
	}
?>