<?PHP
/**
 * SPBAS Storefront API Wrappers for the KB API
 *
 * @package    Storefront_API_Wrappers_KB
 * @author     Andy Rockwell <support@solidphp.com>
 */
class api_kb extends api
	{
	/**
	* Build the article page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param integer $article_id
	* @param integer $category_id
	* @param string $helpful
	* @return array 
	*/
	function article($api_handler, $api_key, $mod, $task, $debug, $article_id, $category_id, $helpful)
		{
		$data=array(
					'article_id' => $article_id, 
					'category_id' => $category_id,
					'helpful' => $helpful,
					);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the bookmarks page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $bookmarks e.g. $_COOKIE['bookmarks']
	* @return array 
	*/
	function bookmarks($api_handler, $api_key, $mod, $task, $debug, $bookmarks)
		{
		$data=array('bookmarks' => $bookmarks);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the down for maintenance page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function down_for_maintenance($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Build the glossary page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $letter
	* @return array 
	*/
	function glossary($api_handler, $api_key, $mod, $task, $debug, $letter)
		{
		$data=array('letter' => $letter);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the index page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function index($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Build the listings page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param integer $category_id
	* @return array 
	*/
	function listings($api_handler, $api_key, $mod, $task, $debug, $category_id)
		{
		$data=array('category_id' => $category_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the print page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param integer $article_id
	* @return array 
	*/
	function print_page($api_handler, $api_key, $mod, $task, $debug, $article_id)
		{
		$data=array('article_id' => $article_id);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}

	/**
	* Build the private page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @return array 
	*/
	function build_private($api_handler, $api_key, $mod, $task, $debug)
		{
		return api::query($api_handler, $api_key, $mod, $task, array(), $debug);
		}

	/**
	* Build the search page.
	*
	* @uses This function is a wrapper for api::query()
	* @see api::query()
	*
	* @param string $api_handler
	* @param string $api_key
	* @param string $mod
	* @param string $task
	* @param boolean $debug
	* @param string $search
	* @return array 
	*/
	function search($api_handler, $api_key, $mod, $task, $debug, $search)
		{
		$data=array('search' => $search);

		return api::query($api_handler, $api_key, $mod, $task, $data, $debug);
		}
	}
?>