<?PHP if (!defined('SAFE')) { die('invalid'); }

if (!x('product_id')) { die(header("Location: index.php")); }

$errors=array();

if (x('add_to_cart'))
	{
	$addons='';
	foreach((array)$_POST['addons'] as $addon_id) 
		{
		if ($addons) { $addons.=','; }
		$addons.=$addon_id;
		}

	// check for extended requirements such as domains for hosting
	$request=api_order_forms::extended_requirements(
			$conf['api_handler'], 
			$conf['api_key'], 
			'order_forms', 
			'extended_requirements', 
			false, // set to true for debug
			$_COOKIE['cart_session'], 
			$product_id=x('product_id'), 
			$sku_id=x('sku_id'), 
			$package_id=(x('package_id')?x('package_id'):0), 
			$addons
			);

	if (empty($request['errors'])&&$request['extended_requirements'])
		{
		$querystring=array();
		$querystring['product_id']=$product_id;
		$querystring['sku_id']=$sku_id;
		if ($package_id) { $querystring['package_id']=$package_id; }
		if ($addons) { $querystring['addons']=$addons; }
		$link=href('hosting', $querystring);
		die(header("Location: {$link}"));
		}
	elseif (!empty($request['errors']))
		{
		$errors=$request['errors']; 
		unset($_POST['sku_id']);
		}

	 // No extended requirements, let's proceed!
	if (empty($request['errors']))
		{
		$request=api_order_forms::add_to_cart(
				$conf['api_handler'], 
				$conf['api_key'], 
				'order_forms', 
				'add_to_cart', 
				false, // set to true for debug
				$_COOKIE['cart_session'], 
				x('product_id'), 
				x('sku_id'), 
				(x('package_id')?x('package_id'):0), 
				$addons
				);
	
		if (empty($request['errors'])&&$request['show-upsell'])
			{
			$querystring=array();
			$querystring['parent_item_id']=$request['parent_item_id'];
			$link=href('purchase_options', $querystring);
			die(header("Location: {$link}"));
			}
		elseif (empty($request['errors']))
			{
			$link=href('view_cart');
			die(header("Location: {$link}"));
			}
		else 
			{ 
			$errors=$request['errors']; 
			unset($_POST['sku_id']);
			}
		}
	}

$request=api_order_forms::product(
		$conf['api_handler'], 
		$conf['api_key'], 
		'order_forms', 
		'product', 
		false, // set to true for debug
		$_COOKIE['cart_session'], 
		$_COOKIE['customer_session'], 
		x('product_id'), 
		x('sku_id'), 
		(x('category_id')?x('category_id'):0)
		); 

$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];
if ($conf['site']['status']=='Down for Maintenance')
	{ 
	$link=href('down_for_maintenance');
	die(header("Location: {$link}"));
	}
else if ($conf['site']['status']=='Private')
	{
	$link=href('private');
	die(header("Location: {$link}"));
	}

$category=$request['category']; // pr($category);
$product=$request['product'];
$skus=$request['skus']; // pr($skus);
$addons=$request['addons']; // pr($addons);
$cart=$request['cart'];
$price_sheet_id=$request['price_sheet_id'];
$price_sheets=$request['price_sheets'];
$currency_options=$request['currency_options']; 
$price_sheet_id=$request['price_sheet_id']; 
unset($request);

// the currency select box
$currency_select=forms::select('price_sheet_id', 0, $currency_options, $price_sheet_id, "onchange='choose_currency(\"{$_COOKIE['cart_session']}\", \"{$conf['site']['id']}\");'", 0, 0);
$currency_options=(is_array($currency_options)&&!empty($currency_options)&&count($currency_options)>1);

function prepare_product($data)
	{
	$buffer=array();

	$buffer['id']=$data['id'];
	$buffer['link']=href('product', array('category_id'=>x('category_id')));
	$buffer['name']=$data['name'];
	$buffer['long_description']=nl2br(htmlspecialchars($data['long_description']));

	return $buffer;
	}

function prepare_sku($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	$buffer['id']=$data['id'];
	$buffer['link']=href('product', array('category_id'=>x('category_id')));
	$buffer['name']=$data['name'];
	$buffer['name']=wordwrap($buffer['name'], 30, '<br />', true);
	$buffer['setup_fee']=($data['pricing']['setup_fee']>0)?$data['pricing']['formatted_setup_fee']:'-';
	$buffer['price']=$data['pricing']['formatted_price'];
	$buffer['recurring']=($data['pricing']['price_recurring']>0&&$data['payment_type']=='Recurring')?$data['pricing']['formatted_price_recurring']:'-';
	$buffer['purchase']=forms::submit('', 0, _e('add_to_cart'), " onclick='product_selection({$data['id']}); return false;'", 'submit_nm', false);

	return $buffer;
	}

function prepare_addons($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	$buffer['id']=$data['id'];
	$buffer['link']=href('product', array('category_id'=>x('category_id')));
	$buffer['name']=$data['product']['name'];
	$buffer['short_description']=$data['product']['short_description'];
	$buffer['long_description']=$data['product']['long_description'];
	$buffer['name'].=" - ".$data['name'];
	$buffer['name']=wordwrap($buffer['name'], 30, '<br />', true);
	$buffer['setup_fee']=($data['pricing']['setup_fee']>0)?$data['pricing']['formatted_setup_fee']:'-';
	$buffer['price']=$data['pricing']['formatted_price'];
	$buffer['recurring']=($data['pricing']['price_recurring']>0&&$data['payment_type']=='Recurring')?$data['pricing']['formatted_price_recurring']:'-';
	$buffer['purchase']=forms::checkbox('', 'addons[]', $data['id'], false, false, false, false);

	return $buffer;
	}

$category_id=array();
if (x('category_id'))
	{
	$category_id=array('category_id'=>x('category_id'));
	}
?>