<?php if (!defined('SAFE')) { die('invalid'); }

$request=api_order_forms::cart(
		$conf['api_handler'], 
		$conf['api_key'], 
		'order_forms', 
		'cart', 
		false, // set to true for debug
		x('category_id')?x('category_id'):0, 
		x('cart_session')?x('cart_session'):0, 
		x('customer_session')?x('customer_session'):0
		);

$conf['localization']=$request['localization'];
$categories_base=$request['categories_base']; // pr($categories_base);
$conf['site']=$request['conf'];
if ($conf['site']['status']=='Down for Maintenance'||empty($categories_base))
	{
	$link=href('down_for_maintenance');
	die(header("Location: {$link}"));
	}
else if ($conf['site']['status']=='Private')
	{
	$link=href('private');
	die(header("Location: {$link}"));
	}
else if ($request['session_locked']=='Yes')
	{
	set_cookie('cart_session', 0, time()-2538000);
	$link=href('cart');
	die(header("Location: {$link}"));
	}
$tlc=$request['tlc']; // pr($tlc);
$cart=$request['cart'];
$is_default=$request['is_default'];
$currency_options=$request['currency_options'];
$price_sheet_id=$request['price_sheet_id']; 
unset($request);

// set a default category
if (!x('category_id')&&$is_default)
	{
	$_GET['category_id']=$is_default;
	}
// END: set a default category

// the currency select box
$currency_select=forms::select('price_sheet_id', 0, $currency_options, $price_sheet_id, "onchange='choose_currency(\"{$_COOKIE['cart_session']}\", \"{$conf['site']['id']}\");'", 0, 0);
$currency_options=(is_array($currency_options)&&!empty($currency_options)&&count($currency_options)>1);

function prepare_category($data, $categories, $tlc)
	{ 
	$buffer=array();

	$buffer['id']=$data['id'];
	$buffer['link']=href('cart', array('category_id'=>$data['id']));

	
	$expand=false;
	$name="<a href='{$buffer['link']}'>{$data['name']}</a>";
	$tree=explode('.', x('category_id')); // echo $data['id']; 
	if (in_array($data['id'], $tree))
		{
		$name=$data['name'];
		$expand=true;
		}

	$buffer['expand']=$expand;
	$buffer['style']=($expand)?" class='on'":'';
	$buffer['name']=$name;
	$buffer['products']=$data['products'];

	$buffer['sub']=$data['sub'];

	return $buffer;
	}

function prepare_sub_category($data, $category_id)
	{
	$buffer=array();

	$buffer['id']=$data['id'];
	$buffer['link']=href('cart', array('category_id'=>$category_id.'.'.$data['id']));
	$buffer['name']=$data['name'];

	return $buffer;
	}

function prepare_product($data, $key)
	{
	$buffer=array();

	$buffer['id']=$data['id'];
	$buffer['link']=href('product', array('product_id'=> $data['id'], 'category_id'=>x('category_id')));
	$buffer['name']=$data['name'];
	$buffer['short_description']=nl2br($data['short_description']);

	$buffer['border']=(($key+1)==count($GLOBALS['category']['products']))?" class='no_border'":'';

	return $buffer;
	}

$choose_products=array();
if (x('category_id'))
	{
	$choose_products=array('category_id'=>x('category_id'));
	}