<?php if (!defined('SAFE')) { die('invalid'); }

$request=api_order_forms::payment(
		$conf['api_handler'], 
		$conf['api_key'], 
		'order_forms', 
		'payment', 
		false, // set to true for debug
		$_COOKIE['cart_session'],
		($_COOKIE['customer_session']?$_COOKIE['customer_session']:0),
		urlencode(base64_encode(serialize($_POST)))
		);

if ($request['go_ideal']) { die(header("Location: {$request['go_ideal']}")); } // iDEAL gateway
$conf['localization']=$request['localization'];
$conf['site']=$request['conf'];

if ($conf['site']['status']=='Down for Maintenance')
	{
	$link=href('down_for_maintenance');
	die(header("Location: {$link}"));
	}
else if ($conf['site']['status']=='Private')
	{
	$link=href('private');
	die(header("Location: {$link}"));
	}
else if ($request['session_locked']=='Yes')
	{
	set_cookie('cart_session', 0, time()-2538000);
	$link=href('cart');
	die(header("Location: {$link}"));
	}

$cart=$request['cart']; // pr($cart);
if (empty($cart)||!is_array($cart))
	{
	$link=href('view_cart');
	die(header("Location: {$link}"));
	}
$total_due_today=$request['total_due_today']; // pr($cart);
$total_due_today_formatted=$request['total_due_today_formatted']; // pr($cart);

$pay_gateways=$request['pay_gateways']; // pr($pay_gateways);
$pay_gateway_select=$request['pay_gateway_select']; // pr($pay_gateways);
$pay_gateway_form=$request['pay_gateway_form']; // pr($pay_gateway_form); 
$recurring=$request['recurring']; // pr($recurring); 
$default_gateway=array_keys($pay_gateway_form);
$default_gateway=$default_gateway[0];
$promotion_code=$request['promotion_code'];
$promotion_code_description=": {$request['promotion_code_description']}";
$promotion_code_discount=$request['total_discounts_formatted'];
$taxes=$request['taxes']; // pr($taxes);
$tax=$request['tax_total'];
$tax_total=$request['tax_total_formatted'];
if ($request['errors']) { $errors=array_merge($request['errors'], $errors); }
$currency_options=$request['currency_options']; 
$price_sheet_id=$request['price_sheet_id']; 
$free_trial_check=$request['free_trial_check']; 
unset($request); // pr($cart);

if ($free_trial_check=='failed')
	{
	$link=href('view_cart');
	die(header("Location: {$link}"));
	}

// the currency select box
$currency_select=forms::select('price_sheet_id', 0, $currency_options, $price_sheet_id, "onchange='choose_currency(\"{$_COOKIE['cart_session']}\", \"{$conf['site']['id']}\");'", 0, 0);
$currency_options=(is_array($currency_options)&&!empty($currency_options)&&count($currency_options)>1);

function prepare_cart($data)
	{
	$buffer=array();

	$buffer['alt']=(!ooe($GLOBALS['m3']+=1))?"class='alt'":'';

	$buffer['cart_item_id']=$data['cart_item_id'];

	$buffer['id']=$data['id'];
	$buffer['name']=$data['product'];
	$buffer['setup_fee']=$data['setup_fee_formatted'];
	if ($data['setup_fee_old_formatted']) { $buffer['setup_fee']="{$data['setup_fee_old_formatted']}<br />{$buffer['setup_fee']}"; }
	$buffer['price']=$data['price_formatted'];
	if ($data['price_old_formatted']) { $buffer['price']="{$data['price_old_formatted']}<br />{$buffer['price']}"; }
	$buffer['recurring']=$data['price_recurring_formatted'];
	if ($data['price_recurring_old_formatted']) { $buffer['recurring']="{$data['price_recurring_old_formatted']}<br />{$buffer['recurring']}";}
	$buffer['qty']=$data['qty'];

	$link=href('view_cart');
	$buffer['change']="<a href='{$link}'>"._w('change').'</a>';

	return $buffer;
	}