<?php 
error_reporting(6135);
ini_set('display_errors', '1');
define('SAFE', true);

/**
* Recursively search for the configuration file!
* 
* @return string 
*/
function start_storefront()
	{
	$try=''; 
	while (strlen($try)<=3)
		{
		$conf="{$try}m3_configuration.php";
		if (file_exists($conf)) {  return $conf; }
		$try.='../';
		}

	return false;
	}

// start m3
$installed=start_storefront();
if (!$installed) { die(header('Location: ../install')); }
$spbas='order';
define('SPBAS', $spbas);
include $installed;
unset($spbas);

include 'includes/globals.php';
$conf['template']=getTemplatePath($conf['template']);

clear_cache();

// What to run?
$mod='order_forms';
$task=($task=x('task', false, 'gpc'))?$task:'cart';

// Validate the task.
$task=in_array($task, $conf['valid_tasks'])?$task:'cart';

// make sure the IDs are integer
foreach (array('parent_package_id','parent_item_id','tld_id','package_id','product_id','sku_id','country_id','price_sheet_id','order_form_id') as $key)
	{
	if (isset($_GET[$key])) { $_GET[$key]=intval($_GET[$key]); }
	if (isset($_POST[$key])) { $_POST[$key]=intval($_POST[$key]); }
	if (isset($_COOKIE[$key])) { $_COOKIE[$key]=intval($_COOKIE[$key]); }
	}

// make sure the IDs are flot values
foreach (array('category_id') as $key)
	{
	if (isset($_GET[$key])) { $_GET[$key]=floatval($_GET[$key]); }
	if (isset($_POST[$key])) { $_POST[$key]=floatval($_POST[$key]); }
	if (isset($_COOKIE[$key])) { $_COOKIE[$key]=floatval($_COOKIE[$key]); }
	}

// add the resold customer ID to the session if needed
if ($_GET['rsid'])
	{
	$request=api_order_forms::start_session(
			$conf['api_handler'], 
			$conf['api_key'], 
			'order_forms', 
			'start_session', 
			false // set to true for debug 
			);

	$_COOKIE['cart_session']=$request['cart_session'];

	$request=api_order_forms::reseller_log_customer_id(
			$conf['api_handler'], 
			$conf['api_key'], 
			'order_forms', 
			'reseller_log_customer_id', 
			false, // set to true for debug 
			$_COOKIE['cart_session'],
			$_GET['rsid']
			);

	set_cookie('cart_session', 0, time()-2538000);
	set_cookie('cart_session', $_COOKIE['cart_session'], time()+2538000);

	$link=href('cart');
	die(header("Location: {$link}"));
	}

// start a session if needed
elseif (!$_COOKIE['cart_session']&&in_array($task, array('cart', 'product', 'view_cart')))
	{ 
	$request=api_order_forms::start_session(
			$conf['api_handler'], 
			$conf['api_key'], 
			'order_forms', 
			'start_session', 
			false // set to true for debug 
			);

	set_cookie('cart_session', 0, time()-2538000);
	set_cookie('cart_session', $request['cart_session'], time()+2538000);
	$_COOKIE['cart_session']=$request['cart_session'];
	}

// get the available language switcher
$switch=api_order_forms::available_languages(
		$conf['api_handler'], 
		$conf['api_key'], 
		'order_forms', 
		'available_languages', 
		false // set to true for debug 
		);

// change the language on demand
if ($_GET['change_language']&&strlen($_GET['change_language'])==5) 
	{ 
	$_COOKIE['change_language']=$_GET['change_language'];
	set_cookie('change_language', 0); 
	set_cookie('change_language', $_GET['change_language']); 
	}

// try and change the language automatically
else if (!$_COOKIE['change_language']&&$detected_language=detect_browser_language())
	{
	if (in_array($detected_language, (array)$switch['available_languages_array']))
		{
		$_COOKIE['change_language']=$detected_language;
		set_cookie('change_language', 0); 
		set_cookie('change_language', $_GET['change_language']);
		unset($detected_language);
		}
	}

// got a cookie and detected languages
else if ($_COOKIE['change_language']&&$detected_language)
	{
	// does the cookie contain a language that is actually installed?
	if (!in_array($_COOKIE['change_language'], (array)$switch['available_languages_array']))
		{
		// nope, let's default to en-us and rmeove the cookie
		$_COOKIE['change_language']='en-us';
		set_cookie('change_language', 0); 
		}
	}

$errors = array();

// CSRF
// ----------------------------------------------------------------------------
$request=api_order_forms::crsf_validate(
	$conf['api_handler'], 
	$conf['api_key'], 
	'order_forms', 
	'csrf_validate', 
	false, // set to true for debug 
	$_COOKIE['cart_session'],
	$_POST['csrf'],
	$_POST
);
$isValidCSRF = (isset($request['isValidCSRF']) && $request['isValidCSRF']);
if (!$isValidCSRF && !empty($request['errors'])) {
	$errors = array_merge($errors, $request['errors']);
}
define(VALID_CSRF, $isValidCSRF);
define(CSRF, $request['csrf']);
unset($request, $isValidCSRF, $_POST['csrf']);
// ----------------------------------------------------------------------------
// END: CSRF

if (file_exists($m3="compiler/{$task}.php")) { include_once $m3; }

if (x('rss')) 
	{ 
	header("Content-type: application/xml"); 
	$m3="templates/{$conf['template']}/{$task}_rss.php";
	if (file_exists($m3)) { include_once $m3; }
	exit;
	}

$m3="templates/{$conf['template']}/header.php";
if ($task=='invoice') { $m3="templates/{$conf['template']}/header_print.php"; } 
include_once $m3;

$m3="templates/{$conf['template']}/{$task}.php";
if (file_exists($m3)) { include_once $m3; }

$m3="templates/{$conf['template']}/footer.php";
if ($task=='invoice') { $m3="templates/{$conf['template']}/footer_print.php"; }
include_once $m3;